// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_I_FUNCTOR_HPP
#define ED_I_FUNCTOR_HPP

#include "meta_Functor.hpp"

#include <cstdint>
#include <tuple>

namespace ed
{
   template <char ConstOrMutatingCallOp, typename ReturnType, typename... ArgumentTypes> requires(meta_Functor::flags::ConstOrMutatingCallOp::MustBeCorrect<ConstOrMutatingCallOp>{}, true)
   class I_Functor :public meta_Functor::BaseInterface_T<ConstOrMutatingCallOp, ReturnType, ArgumentTypes...>
   {
      template <uintmax_t Index> struct IndexMustBeValid;

      public:

         /// Destructor

            virtual ~I_Functor() {};

         /// Static variables

            static constexpr uintmax_t numberOfArgs_V               = sizeof...(ArgumentTypes);
            static constexpr char      flag_ConstOrMutatingCallOp_V = ConstOrMutatingCallOp;
            static constexpr bool      hasConstCallOp_V             = meta_Functor::hasTrait::hasConstCallOp_V   <ConstOrMutatingCallOp>;
            static constexpr bool      hasMutatingCallOp_V          = meta_Functor::hasTrait::hasMutatingCallOp_V<ConstOrMutatingCallOp>;

         /// Nested types

            using ReturnType_T    = ReturnType;
            using ArgTypesTuple_T = std::tuple<ArgumentTypes...>;

            template <uintmax_t Index> requires(IndexMustBeValid<Index>{}, true)
               using ArgType_T = std::tuple_element_t<Index, ArgTypesTuple_T>;

         /// Dummy alias

            using IsEdeniumFunctor = void;

      private:

         template <uintmax_t Index> struct IndexMustBeValid { static_assert(Index < numberOfArgs_V, "`Index` template argument must be smaller than `numberOfArgs_V` of this Functor."); };
   };
}

#endif // ED_I_FUNCTOR_HPP
