// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_I_CONTAINER_VIEW_FINITE_AMP_HPP
#define ED_I_CONTAINER_VIEW_FINITE_AMP_HPP

#include "meta_ContainerView_base.hpp"
#include "I_ContainerViewFinite.hpp"
#include "I_ContainerViewAMP.hpp"

#include <cstdint>

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char ConstOrMutatingFunctorCallOp>
      requires(meta_ContainerView::flags::SolidOrAbstract             ::MustBeCorrect<SolidOrAbstract>             {},
               meta_ContainerView::flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>{}, true)
   struct I_ContainerViewFiniteAMP :public I_ContainerViewFinite<StoredType, SolidOrAbstract, ConstOrMutatingFunctorCallOp, 'm'>,
                                    public I_ContainerViewAMP   <StoredType, SolidOrAbstract, 'f', ConstOrMutatingFunctorCallOp>
   {
      /// Destructor

         virtual ~I_ContainerViewFiniteAMP() {};

      /// Methods

         virtual void setSize(const uintmax_t& size) const = 0;
   };
}

#endif // ED_I_CONTAINER_VIEW_FINITE_AMP_HPP
