// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_I_CONTAINER_VIEW_FINITE_HPP
#define ED_I_CONTAINER_VIEW_FINITE_HPP

#include "meta_ContainerView_base.hpp"
#include "I_ContainerViewBase.hpp"

#include <cstdint>

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      requires(meta_ContainerView::flags::SolidOrAbstract             ::MustBeCorrect<SolidOrAbstract>                 {},
               meta_ContainerView::flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>    {},
               meta_ContainerView::flags::ViewPropertiesAlwaysMutable ::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
   class I_ContainerViewFinite :public virtual I_ContainerViewBase<StoredType, SolidOrAbstract, 'f', ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
   {
      public:

         /// Destructor

            virtual ~I_ContainerViewFinite() {};

         /// Methods

            virtual void setSize(const uintmax_t& size) = 0;

      protected:

         mutable uintmax_t m_size;
   };
}

#endif // ED_I_CONTAINER_VIEW_FINITE_HPP
