// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_I_CONTAINER_VIEW_BASE_HPP
#define ED_I_CONTAINER_VIEW_BASE_HPP

#include "meta_ContainerView_base.hpp"

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      requires(meta_ContainerView::flags::SolidOrAbstract             ::MustBeCorrect<SolidOrAbstract>                 {},
               meta_ContainerView::flags::FiniteOrInfinite            ::MustBeCorrect<FiniteOrInfinite>                {},
               meta_ContainerView::flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>    {},
               meta_ContainerView::flags::ViewPropertiesAlwaysMutable ::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
   struct I_ContainerViewBase :public meta_ContainerView::BaseContainerInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite>
   {
      /// Nested types

         using TargetInterface_T  = meta_ContainerView::TargetInterface_T        <StoredType, SolidOrAbstract>;
         using FunctorInterface_T = meta_ContainerView::MappingFunctorInterface_T<ConstOrMutatingFunctorCallOp>;

      /// Destructor

         virtual ~I_ContainerViewBase() {};

      /// Methods

         virtual       TargetInterface_T&  target        ()       = 0;
         virtual const TargetInterface_T&  target        () const = 0;
         virtual       FunctorInterface_T& mappingFunctor() const = 0;

         virtual void setTarget        (TargetInterface_T&  target)         = 0;
         virtual void setMappingFunctor(FunctorInterface_T& mappingFunctor) = 0;

      /// Static variables

         static constexpr bool isSolid_V                       = meta_ContainerView::hasTrait::isSolid_V                      <SolidOrAbstract>;
         static constexpr bool isAbstract_V                    = meta_ContainerView::hasTrait::isAbstract_V                   <SolidOrAbstract>;
         static constexpr bool isFinite_V                      = meta_ContainerView::hasTrait::isFinite_V                     <FiniteOrInfinite>;
         static constexpr bool isInfinite_V                    = meta_ContainerView::hasTrait::isInfinite_V                   <FiniteOrInfinite>;
         static constexpr bool usesFunctorWithConstCallOp_V    = meta_ContainerView::hasTrait::usesFunctorWithConstCallOp_V   <ConstOrMutatingFunctorCallOp>;
         static constexpr bool usesFunctorWithMutatingCallOp_V = meta_ContainerView::hasTrait::usesFunctorWithMutatingCallOp_V<ConstOrMutatingFunctorCallOp>;
         static constexpr bool hasAlwaysMutableProperties_V    = meta_ContainerView::hasTrait::hasAlwaysMutableProperties_V   <ViewPropertiesAlwaysMutable_If_m>;
   };
}

#endif // ED_I_CONTAINER_VIEW_BASE_HPP
