// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_I_CONTAINER_VIEW_AMP_HPP
#define ED_I_CONTAINER_VIEW_AMP_HPP

#include "meta_ContainerView_base.hpp"
#include "I_ContainerViewBase.hpp"

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp>
      requires(meta_ContainerView::flags::SolidOrAbstract             ::MustBeCorrect<SolidOrAbstract>             {},
               meta_ContainerView::flags::FiniteOrInfinite            ::MustBeCorrect<FiniteOrInfinite>            {},
               meta_ContainerView::flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>{}, true)
   class I_ContainerViewAMP :public virtual I_ContainerViewBase<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, 'm'>
   {
      using ViewBase_T = I_ContainerViewBase<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, 'm'>;

      public:

         /// Destructor

            virtual ~I_ContainerViewAMP() {};

         /// Methods

            virtual void setTarget        (const ViewBase_T::TargetInterface_T&  target)         const = 0;
            virtual void setMappingFunctor(      ViewBase_T::FunctorInterface_T& mappingFunctor) const = 0;
   };
}

#endif // ED_I_CONTAINER_VIEW_AMP_HPP
