// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_I_CONTAINER_SOLID_HPP
#define ED_I_CONTAINER_SOLID_HPP

#include "I_Container.hpp"

#include <cstdint>

namespace ed
{
   template <typename StoredType>
   struct I_ContainerSolid :public I_Container<StoredType>
   {
      /// Destructor

         virtual ~I_ContainerSolid() {};

      /// Methods

         virtual void repoint(      StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex)       = 0;
         virtual void repoint(const StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex) const = 0;

      /// Operator overloads

         virtual const StoredType& operator() (const uintmax_t& index) const = 0;
         virtual       StoredType& operator() (const uintmax_t& index)       = 0;

      /// Dummy alias

         using IsEdeniumContainerSolid = void;
   };
}

#endif // ED_I_CONTAINER_SOLID_HPP
