// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_I_CONTAINER_ABSTRACT_HPP
#define ED_I_CONTAINER_ABSTRACT_HPP

#include "I_Container.hpp"

#include <cstdint>

namespace ed
{
   template <typename StoredType>
   struct I_ContainerAbstract :public I_Container<StoredType>
   {
      /// Destructor

         virtual ~I_ContainerAbstract() {};

      /// Methods

         virtual void set(const uintmax_t& index, const StoredType& value) = 0;

      /// Operator overloads

         virtual StoredType operator() (const uintmax_t& index) const = 0;

      /// Dummy alias

         using IsEdeniumContainerAbstract = void;
   };
}

#endif // ED_I_CONTAINER_ABSTRACT_HPP
