// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_FUNDAMENTAL_INT_CONCEPTS_HPP
#define ED_FUNDAMENTAL_INT_CONCEPTS_HPP

#include <type_traits>
#include <concepts>

namespace ed
{
   template <typename T> concept FUNDAMENTAL_INT = std::is_fundamental_v<T> && std::integral<T> && !std::same_as<std::remove_cv_t<T>, bool>;

   template <typename T> concept FUNDAMENTAL_UINT = FUNDAMENTAL_INT<T> && std::unsigned_integral<T>;
   template <typename T> concept FUNDAMENTAL_SINT = FUNDAMENTAL_INT<T> && std::signed_integral<T>;
}

#endif // ED_FUNDAMENTAL_INT_CONCEPTS_HPP
