// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_FUNCTOR_WRAP_HPP
#define ED_FUNCTOR_WRAP_HPP

#include "I_Functor.hpp"
#include "edeniumConfig_debugModeSettings.hpp"

#include <cstdint>

namespace ed
{
   class FunctorWrap :public I_Functor<'c', uintmax_t, const uintmax_t&>
   {
      public:

         /// Constructors

            explicit FunctorWrap(const uintmax_t& modulus) noexcept(!config::debuggingEnabledFor_FunctorWrap_ctor && !config::debuggingEnabledFor_FunctorWrap_setModulus);

         /// Methods

            uintmax_t modulus()                            const noexcept;
            void      setModulus(const uintmax_t& modulus)       noexcept(!config::debuggingEnabledFor_FunctorWrap_setModulus);

         /// Operator overloads

            uintmax_t operator() (const uintmax_t& value) const noexcept override;

      private:

         uintmax_t m_modulus;
   };

   template <uintmax_t Modulus>
   struct FunctorWrap_S :public I_Functor<'c', uintmax_t, const uintmax_t&>
   {
      static_assert(Modulus != 0, "`Modulus` template argument must not be 0.");
      uintmax_t operator() (const uintmax_t& value) const noexcept override { return value % Modulus; }
   };
}

#endif // ED_FUNCTOR_WRAP_HPP
