// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "FunctorWrap.hpp"

#include "_checkInterface_FunctorWrap.hpp"

namespace ed
{
   /// Constructors

      FunctorWrap::FunctorWrap(const uintmax_t& modulus) noexcept(!config::debuggingEnabledFor_FunctorWrap_ctor && !config::debuggingEnabledFor_FunctorWrap_setModulus)
      {
         if constexpr (config::debuggingEnabledFor_FunctorWrap_ctor)
            _checkInterface_FunctorWrap_ctor(modulus);

         setModulus(modulus);
      }

   /// Methods

      uintmax_t FunctorWrap::modulus() const noexcept
      { return m_modulus; }

      void FunctorWrap::setModulus(const uintmax_t& modulus) noexcept(!config::debuggingEnabledFor_FunctorWrap_setModulus)
      {
         if constexpr (config::debuggingEnabledFor_FunctorWrap_setModulus)
            _checkInterface_FunctorWrap_setModulus(modulus);

         m_modulus = modulus;
      }

   /// Operator overloads

      uintmax_t FunctorWrap::operator() (const uintmax_t& value) const noexcept
      { return value % modulus(); }
}
