// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_FUNCTOR_SCALE_HPP
#define ED_FUNCTOR_SCALE_HPP

#include "I_Functor.hpp"

#include <cstdint>

namespace ed
{
   class FunctorScale :public I_Functor<'c', uintmax_t, const uintmax_t&>
   {
      public:

         /// Constructors

            explicit FunctorScale(const uintmax_t& factor) noexcept;

         /// Methods

            uintmax_t factor   ()                        const noexcept;
            void      setFactor(const uintmax_t& factor)       noexcept;

         /// Operator overloads

            uintmax_t operator() (const uintmax_t& value) const noexcept override;

      private:

         uintmax_t m_factor;
   };

   template <uintmax_t Factor>
   struct FunctorScale_S :public I_Functor<'c', uintmax_t, const uintmax_t&>
   { uintmax_t operator() (const uintmax_t& value) const noexcept override { return value * Factor; } };
}

#endif // ED_FUNCTOR_SCALE_HPP
