// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "FunctorScale.hpp"

namespace ed
{
   /// Constructors

      FunctorScale::FunctorScale(const uintmax_t& factor) noexcept { setFactor(factor); }

   /// Methods

      uintmax_t FunctorScale::factor   ()                        const noexcept { return m_factor;   }
      void      FunctorScale::setFactor(const uintmax_t& factor)       noexcept { m_factor = factor; }

   /// Operator overloads

      uintmax_t FunctorScale::operator() (const uintmax_t& value) const noexcept { return value * factor(); }
}
