// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_FUNCTOR_REVERSE_HPP
#define ED_FUNCTOR_REVERSE_HPP

#include "I_Functor.hpp"

#include <cstdint>

namespace ed
{
   class FunctorReverse :public I_Functor<'c', uintmax_t, const uintmax_t&>
   {
      public:

         /// Constructors

            explicit FunctorReverse(const uintmax_t& maxValue) noexcept;

         /// Methods

            uintmax_t maxValue()                             const noexcept;
            void      setMaxValue(const uintmax_t& maxValue)       noexcept;

         /// Operator overloads

            uintmax_t operator() (const uintmax_t& value) const noexcept override;

      private:

         uintmax_t m_maxValue;
   };

   template <uintmax_t MaxValue>
   struct FunctorReverse_S :public I_Functor<'c', uintmax_t, const uintmax_t&>
   { uintmax_t operator() (const uintmax_t& value) const noexcept override { return MaxValue - value; } };
}

#endif // ED_FUNCTOR_REVERSE_HPP
