// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "FunctorReverse.hpp"

namespace ed
{
   /// Constructors

      FunctorReverse::FunctorReverse(const uintmax_t& maxValue) noexcept { setMaxValue(maxValue); }

   /// Methods

      uintmax_t FunctorReverse::maxValue()                             const noexcept { return m_maxValue;     }
      void      FunctorReverse::setMaxValue(const uintmax_t& maxValue)       noexcept { m_maxValue = maxValue; }

   /// Operator overloads

      uintmax_t FunctorReverse::operator() (const uintmax_t& value) const noexcept { return maxValue() - value; }
}
