// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_FUNCTOR_OFFSET_HPP
#define ED_FUNCTOR_OFFSET_HPP

#include "I_Functor.hpp"

#include <cstdint>

namespace ed
{
   class FunctorOffset :public I_Functor<'c', uintmax_t, const uintmax_t&>
   {
      public:

         /// Constructors

            explicit FunctorOffset(const uintmax_t& offset) noexcept;

         /// Methods

            uintmax_t offset   ()                        const noexcept;
            void      setOffset(const uintmax_t& offset)       noexcept;

         /// Operator overloads

            uintmax_t operator() (const uintmax_t& value) const noexcept override;

      private:

         uintmax_t m_offset;
   };

   template <uintmax_t Offset>
   struct FunctorOffset_S :public I_Functor<'c', uintmax_t, const uintmax_t&>
   { uintmax_t operator() (const uintmax_t& value) const noexcept override { return value + Offset; } };
}

#endif // ED_FUNCTOR_OFFSET_HPP
