// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "FunctorOffset.hpp"

namespace ed
{
   /// Constructors

      FunctorOffset::FunctorOffset(const uintmax_t& offset) noexcept { setOffset(offset); }

   /// Methods

      uintmax_t FunctorOffset::offset   ()                        const noexcept { return m_offset;   }
      void      FunctorOffset::setOffset(const uintmax_t& offset)       noexcept { m_offset = offset; }

   /// Operator overloads

      uintmax_t FunctorOffset::operator() (const uintmax_t& value) const noexcept { return value + offset(); }
}
