// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_FUNCTOR_CONCEPTS_HPP
#define ED_FUNCTOR_CONCEPTS_HPP

#include "I_Functor.hpp"
#include "_isInterface_Functor_V.hpp"

#include <type_traits>
#include <concepts>
#include <tuple>

namespace ed
{
   template <typename T> concept FUNCTOR = requires { typename T::IsEdeniumFunctor; } && (!std::is_const_v<T> || T::hasConstCallOp_V);

   template <typename T> concept FUNCTOR_WITH_CONST_CALL_OP    = FUNCTOR<T> && T::hasConstCallOp_V;
   template <typename T> concept FUNCTOR_WITH_MUTATING_CALL_OP = FUNCTOR<T> && T::hasMutatingCallOp_V;

   template <typename T> concept FUNCTOR_INTERFACE_WITH_CONST_CALL_OP    = _isInterface_FunctorWithConstCallOp_V   <T>;
   template <typename T> concept FUNCTOR_INTERFACE_WITH_MUTATING_CALL_OP = _isInterface_FunctorWithMutatingCallOp_V<T>;
   template <typename T> concept FUNCTOR_INTERFACE                       = FUNCTOR_INTERFACE_WITH_CONST_CALL_OP    <T> || FUNCTOR_INTERFACE_WITH_MUTATING_CALL_OP<T>;

   template <typename T, typename ReturnType, typename... ArgumentTypes>
      concept FUNCTOR_WITH_TYPE_SIGNATURE = FUNCTOR<T> && std::same_as<typename T::ReturnType_T, ReturnType> && std::same_as<typename T::ArgTypesTuple_T, std::tuple<ArgumentTypes...>>;
}

#endif // ED_FUNCTOR_CONCEPTS_HPP
