// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_DERIVED_FROM_TEMPLATE_HPP
#define ED_DERIVED_FROM_TEMPLATE_HPP

#include <type_traits>

namespace ed
{
   template <typename Derived, template <typename...> typename Base>
      concept DERIVED_FROM_TEMPLATE = requires(std::remove_cv_t<Derived>& d) { []<typename... Ts>(Base<Ts...>&) {}(d); };
}

#endif // ED_DERIVED_FROM_TEMPLATE_HPP
