// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_XTORS_TPP
#define ED_CONTAINER_VIEW_XTORS_TPP

namespace ed
{
   /// Constructors

      template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::ContainerView(ViewBase_T::TargetInterface_T& target, ViewBase_T::FunctorInterface_T& mappingFunctor) noexcept
            requires(ViewBase_T::isInfinite_V)
            : m_targetIsConst(false)
            {
               m_setTarget(target);
               setMappingFunctor(mappingFunctor);
            }

      template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::ContainerView(const ViewBase_T::TargetInterface_T& target, ViewBase_T::FunctorInterface_T& mappingFunctor) noexcept
            requires(ViewBase_T::isInfinite_V)
            : m_targetIsConst(true)
            {
               m_setTarget(target);
               setMappingFunctor(mappingFunctor);
            }

      template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::ContainerView(ViewBase_T::TargetInterface_T& target, ViewBase_T::FunctorInterface_T& mappingFunctor, const uintmax_t& size) noexcept
            requires(ViewBase_T::isFinite_V)
            : m_targetIsConst(false)
            {
               m_setTarget(target);
               setMappingFunctor(mappingFunctor);
               setSize(size);
            }

      template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::ContainerView(const ViewBase_T::TargetInterface_T& target, ViewBase_T::FunctorInterface_T& mappingFunctor, const uintmax_t& size) noexcept
            requires(ViewBase_T::isFinite_V)
            : m_targetIsConst(true)
            {
               m_setTarget(target);
               setMappingFunctor(mappingFunctor);
               setSize(size);
            }

   /// Destructor

      template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::~ContainerView() {}
}

#endif // ED_CONTAINER_VIEW_XTORS_TPP
