// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_OP_OVERLOADS_TPP
#define ED_CONTAINER_VIEW_OP_OVERLOADS_TPP

#include "_checkInterface_ContainerView.hpp"

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      ConditionalConstReferenceL_T<meta_ContainerView::
                                      BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>::
                                         isSolid_V,
                                   StoredType>
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::operator() (const uintmax_t& index) const
         {
            if constexpr (config::debuggingEnabledFor_ContainerView_op_call && ViewBase_T::isFinite_V)
               _checkInterface_ContainerView_op_call(index, size());

            return target()(m_mapIndex(index));
         }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      StoredType&
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::operator() (const uintmax_t& index)
            requires(ViewBase_T::isSolid_V)
            {
               if constexpr (config::debuggingEnabledFor_ContainerView_op_call && ViewBase_T::isFinite_V)
                  _checkInterface_ContainerView_op_call(index, size());

               return target()(m_mapIndex(index));
            }
}

#endif // ED_CONTAINER_VIEW_OP_OVERLOADS_TPP
