// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_METHODS_PUBLIC_SETTERS_TPP
#define ED_CONTAINER_VIEW_METHODS_PUBLIC_SETTERS_TPP

#include "_checkInterface_ContainerView.hpp"

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::set(const uintmax_t& index, const StoredType& value)
            requires(ViewBase_T::isAbstract_V)
            {
               if constexpr (config::debuggingEnabledFor_ContainerView_set && ViewBase_T::isFinite_V)
                  _checkInterface_ContainerView_set(index, size());

               target().set(m_mapIndex(index), value);
            }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::setTarget(typename ViewBase_T::TargetInterface_T& target) noexcept
         {
            m_targetIsConst = false;
            m_setTarget(target);
         }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::setTarget(const typename ViewBase_T::TargetInterface_T& target) const noexcept
            requires(ViewBase_T::hasAlwaysMutableProperties_V)
            {
               m_targetIsConst = true;
               m_setTarget(target);
            }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::setMappingFunctor(typename ViewBase_T::FunctorInterface_T& mappingFunctor) noexcept
         { m_mappingFunctor = &mappingFunctor; }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::setMappingFunctor(typename ViewBase_T::FunctorInterface_T& mappingFunctor) const noexcept
            requires(ViewBase_T::hasAlwaysMutableProperties_V)
            { m_mappingFunctor = &mappingFunctor; }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::setSize(const uintmax_t& size) noexcept
            requires(ViewBase_T::isFinite_V)
            { ViewBase_T::m_size = size; }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::setSize(const uintmax_t& size) const noexcept
            requires(ViewBase_T::isFinite_V && ViewBase_T::hasAlwaysMutableProperties_V)
            { ViewBase_T::m_size = size; }
}

#endif // ED_CONTAINER_VIEW_METHODS_PUBLIC_SETTERS_TPP
