// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_METHODS_PUBLIC_GETTERS_TPP
#define ED_CONTAINER_VIEW_METHODS_PUBLIC_GETTERS_TPP

#include "_checkInterface_ContainerView.hpp"

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>::
      TargetInterface_T&
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::target() noexcept(!config::debuggingEnabledFor_ContainerView_target)
         {
            if constexpr (config::debuggingEnabledFor_ContainerView_target)
               _checkInterface_ContainerView_target(m_targetIsConst);

            return *m_target;
         }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      const meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>::
      TargetInterface_T&
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::target() const noexcept
         { return *m_target; }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>::
      FunctorInterface_T&
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::mappingFunctor() const noexcept
         { return *m_mappingFunctor; }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      uintmax_t
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::size() const noexcept
            requires(ViewBase_T::isFinite_V)
            { return ViewBase_T::m_size; }
}

#endif // ED_CONTAINER_VIEW_METHODS_PUBLIC_GETTERS_TPP
