// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_METHODS_PRIVATE_TPP
#define ED_CONTAINER_VIEW_METHODS_PRIVATE_TPP

#include "_checkInterface_ContainerView.hpp"

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      uintmax_t
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::m_mapIndex(const uintmax_t& index) const
         { return (*m_mappingFunctor)(index); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::m_setTarget(const typename ViewBase_T::TargetInterface_T& target) const
         { m_target = &const_cast<ViewBase_T::TargetInterface_T&>(target); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m>
   template <POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
      void
         ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
         ::m_repointGeneric(AdequatePtrType& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex)
            requires(ViewBase_T::isSolid_V)
            {
               if constexpr (config::debuggingEnabledFor_ContainerView_repoint && ViewBase_T::isFinite_V)
                  _checkInterface_ContainerView_repoint(pointer, currentIndex, targetIndex, *this);

               target().repoint(pointer, m_mapIndex(currentIndex), m_mapIndex(targetIndex));
            }
}

#endif // ED_CONTAINER_VIEW_METHODS_PRIVATE_TPP
