// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_PLUS_XTORS_TPP
#define ED_CONTAINER_VIEW_PLUS_XTORS_TPP

#include <utility>

namespace ed
{
   /// Public

      /// Constructors

         template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
            ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
            ::ContainerViewPlus(ViewBase_T::TargetInterface_T& target, const StoredFunctorType& functorToCopy)
               requires(ViewBase_T::isInfinite_V)
               : m_storedFunctorPtr(std::make_shared<StoredFunctorType>(functorToCopy)), m_view(target, *m_storedFunctorPtr) {}

         template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
            ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
            ::ContainerViewPlus(const ViewBase_T::TargetInterface_T& target, const StoredFunctorType& functorToCopy)
               requires(ViewBase_T::isInfinite_V)
               : m_storedFunctorPtr(std::make_shared<StoredFunctorType>(functorToCopy)), m_view(target, *m_storedFunctorPtr) {}

         template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
            ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
            ::ContainerViewPlus(ViewBase_T::TargetInterface_T& target, const StoredFunctorType& functorToCopy, const uintmax_t& size)
               requires(ViewBase_T::isFinite_V)
               : m_storedFunctorPtr(std::make_shared<StoredFunctorType>(functorToCopy)), m_view(target, *m_storedFunctorPtr, size) {}

         template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
            ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
            ::ContainerViewPlus(const ViewBase_T::TargetInterface_T& target, const StoredFunctorType& functorToCopy, const uintmax_t& size)
               requires(ViewBase_T::isFinite_V)
               : m_storedFunctorPtr(std::make_shared<StoredFunctorType>(functorToCopy)), m_view(target, *m_storedFunctorPtr, size) {}

         template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
            ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
            ::ContainerViewPlus(const ThisType_T& arg)
               : m_storedFunctorPtr(std::make_shared<StoredFunctorType>(arg.storedFunctor())),
                 m_view            (arg.m_view)
               { m_correctMappingFunctorIfItIs(arg.storedFunctor()); }

         template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
            ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
            ::ContainerViewPlus(ThisType_T&& arg) noexcept
               : m_storedFunctorPtr(arg.storedFunctorPtr()),
                 m_view            (std::move(arg.m_view))
               {
                  m_correctMappingFunctorIfItIs(arg.storedFunctor());
                  arg.m_storedFunctorPtr.reset();
               }

      /// Destructor

         template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
            ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
            ::~ContainerViewPlus() {}
}

#endif // ED_CONTAINER_VIEW_PLUS_XTORS_TPP
