// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_PLUS_OP_OVERLOADS_TPP
#define ED_CONTAINER_VIEW_PLUS_OP_OVERLOADS_TPP

#include <utility>

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      ConditionalConstReferenceL_T<meta_ContainerView::
                                      BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType::flag_ConstOrMutatingCallOp_V, ViewPropertiesAlwaysMutable_If_m>::
                                         isSolid_V,
                                   StoredType>
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::operator() (const uintmax_t& index) const
         { return m_view(index); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      StoredType&
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::operator() (const uintmax_t& index)
            requires(ViewBase_T::isSolid_V)
            { return m_view(index); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>&
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::operator= (const ThisType_T& arg)
         {
            if(this != &arg)
            {
               StoredFunctorType& argStoredFunctor = arg.storedFunctor();

               m_storedFunctorPtr = std::make_shared<StoredFunctorType>(argStoredFunctor);
               m_view             = arg.m_view;
               m_correctMappingFunctorIfItIs(argStoredFunctor);
            }
            return *this;
         }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>&
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::operator= (ThisType_T&& arg) noexcept
         {
            if(this != &arg)
            {
               m_storedFunctorPtr = arg.storedFunctorPtr();
               m_view             = std::move(arg.m_view);
               m_correctMappingFunctorIfItIs(arg.storedFunctor());
               arg.m_storedFunctorPtr.reset();
            }
            return *this;
         }
}

#endif // ED_CONTAINER_VIEW_PLUS_OP_OVERLOADS_TPP
