// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_SETTERS_TPP
#define ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_SETTERS_TPP

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::set(const uintmax_t& index, const StoredType& value)
            requires(ViewBase_T::isAbstract_V)
            { m_view.set(index, value); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::setTarget(typename ViewBase_T::TargetInterface_T& target) noexcept
         { m_view.setTarget(target); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::setTarget(const typename ViewBase_T::TargetInterface_T& target) const noexcept
            requires(ViewBase_T::hasAlwaysMutableProperties_V)
            { m_view.setTarget(target); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::setMappingFunctor(typename ViewBase_T::FunctorInterface_T& mappingFunctor) noexcept
         { m_view.setMappingFunctor(mappingFunctor); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::setMappingFunctor(typename ViewBase_T::FunctorInterface_T& mappingFunctor) const noexcept
            requires(ViewBase_T::hasAlwaysMutableProperties_V)
            { m_view.setMappingFunctor(mappingFunctor); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::setSize(const uintmax_t& size) noexcept
            requires(ViewBase_T::isFinite_V)
            { m_view.setSize(size); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::setSize(const uintmax_t& size) const noexcept
            requires(ViewBase_T::isFinite_V && ViewBase_T::hasAlwaysMutableProperties_V)
            { m_view.setSize(size); }
}

#endif // ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_SETTERS_TPP
