// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_OTHER_TPP
#define ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_OTHER_TPP

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::repoint(StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex)
            requires(ViewBase_T::isSolid_V)
            { m_view.repoint(pointer, currentIndex, targetIndex); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      void
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::repoint(const StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex) const
            requires(ViewBase_T::isSolid_V)
            { m_view.repoint(pointer, currentIndex, targetIndex); }
}

#endif // ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_OTHER_TPP
