// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_GETTERS_TPP
#define ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_GETTERS_TPP

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType::flag_ConstOrMutatingCallOp_V, ViewPropertiesAlwaysMutable_If_m>::
      TargetInterface_T&
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::target() noexcept(!config::debuggingEnabledFor_ContainerView_target)
         { return m_view.target(); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      const meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType::flag_ConstOrMutatingCallOp_V, ViewPropertiesAlwaysMutable_If_m>::
      TargetInterface_T&
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::target() const noexcept
         { return m_view.target(); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType::flag_ConstOrMutatingCallOp_V, ViewPropertiesAlwaysMutable_If_m>::
      FunctorInterface_T&
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::mappingFunctor() const noexcept
         { return m_view.mappingFunctor(); }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      StoredFunctorType&
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::storedFunctor() const noexcept
         { return *m_storedFunctorPtr; }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      std::shared_ptr<StoredFunctorType>
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::storedFunctorPtr() const noexcept
         { return m_storedFunctorPtr; }

   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m>
      uintmax_t
         ContainerViewPlus<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType, ViewPropertiesAlwaysMutable_If_m>
         ::size() const noexcept
            requires(ViewBase_T::isFinite_V)
            { return m_view.size(); }
}

#endif // ED_CONTAINER_VIEW_PLUS_METHODS_PUBLIC_GETTERS_TPP
