// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_PLUS_HPP
#define ED_CONTAINER_VIEW_PLUS_HPP

#include "CVP_COMPATIBLE_FUNCTOR.hpp"
#include "meta_ContainerView.hpp"
#include "I_Functor.hpp"
#include "I_ContainerViewBase.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "ConditionalTypeModifiers.hpp"
#include "ContainerView.hpp"

#include <type_traits>
#include <cstdint>
#include <memory>

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, CVP_COMPATIBLE_FUNCTOR StoredFunctorType, char ViewPropertiesAlwaysMutable_If_m = ' '>
      requires(meta_ContainerView::flags::SolidOrAbstract            ::MustBeCorrect<SolidOrAbstract>                 {},
               meta_ContainerView::flags::FiniteOrInfinite           ::MustBeCorrect<FiniteOrInfinite>                {},
               meta_ContainerView::flags::ViewPropertiesAlwaysMutable::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
   class ContainerViewPlus
      :public meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType::flag_ConstOrMutatingCallOp_V, ViewPropertiesAlwaysMutable_If_m>
   {
      using ThisType_T = ContainerViewPlus                      <StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType,                               ViewPropertiesAlwaysMutable_If_m>;
      using ViewBase_T = meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType::flag_ConstOrMutatingCallOp_V, ViewPropertiesAlwaysMutable_If_m>;

      public:

         /// Constructors

            explicit ContainerViewPlus(      ViewBase_T::TargetInterface_T& target, const StoredFunctorType& functorToCopy)                                  requires(ViewBase_T::isInfinite_V);
            explicit ContainerViewPlus(const ViewBase_T::TargetInterface_T& target, const StoredFunctorType& functorToCopy)                                  requires(ViewBase_T::isInfinite_V);
            explicit ContainerViewPlus(      ViewBase_T::TargetInterface_T& target, const StoredFunctorType& functorToCopy, const uintmax_t& size)           requires(ViewBase_T::isFinite_V);
            explicit ContainerViewPlus(const ViewBase_T::TargetInterface_T& target, const StoredFunctorType& functorToCopy, const uintmax_t& size)           requires(ViewBase_T::isFinite_V);
                     ContainerViewPlus(const ThisType_T&  arg);
                     ContainerViewPlus(      ThisType_T&& arg)                                                                                     noexcept;

         /// Destructor

            virtual ~ContainerViewPlus();

         /// Methods

            void repoint(      StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex)       requires(ViewBase_T::isSolid_V); //override
            void repoint(const StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex) const requires(ViewBase_T::isSolid_V); //override

            /// Getters

                     ViewBase_T::TargetInterface_T&     target          ()       noexcept(!config::debuggingEnabledFor_ContainerView_target)                                     override;
               const ViewBase_T::TargetInterface_T&     target          () const noexcept                                                                                        override;
                     ViewBase_T::FunctorInterface_T&    mappingFunctor  () const noexcept                                                                                        override;
                     uintmax_t                          size            () const noexcept                                                    requires(ViewBase_T::isFinite_V); //override
                     StoredFunctorType&                 storedFunctor   () const noexcept;
                     std::shared_ptr<StoredFunctorType> storedFunctorPtr() const noexcept;

            /// Setters

               void set              (const uintmax_t&                      index,
                                      const StoredType&                     value)                         requires(ViewBase_T::isAbstract_V);                                           //override
               void setTarget        (      ViewBase_T::TargetInterface_T&  target)               noexcept                                                                                 override;
               void setTarget        (const ViewBase_T::TargetInterface_T&  target)         const noexcept requires(ViewBase_T::hasAlwaysMutableProperties_V);                           //override
               void setMappingFunctor(      ViewBase_T::FunctorInterface_T& mappingFunctor)       noexcept                                                                                 override;
               void setMappingFunctor(      ViewBase_T::FunctorInterface_T& mappingFunctor) const noexcept requires(ViewBase_T::hasAlwaysMutableProperties_V);                           //override
               void setSize          (const uintmax_t&                      size)                 noexcept requires(ViewBase_T::isFinite_V);                                             //override
               void setSize          (const uintmax_t&                      size)           const noexcept requires(ViewBase_T::isFinite_V && ViewBase_T::hasAlwaysMutableProperties_V); //override

         /// Operator overloads

            ConditionalConstReferenceL_T<meta_ContainerView::BaseViewInterface_T
                                            <StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType::flag_ConstOrMutatingCallOp_V, ViewPropertiesAlwaysMutable_If_m>
                                         ::isSolid_V, StoredType> operator() (const uintmax_t& index) const;                                  //override
            StoredType&                                           operator() (const uintmax_t& index)        requires(ViewBase_T::isSolid_V); //override

            ThisType_T& operator= (const ThisType_T&  arg);
            ThisType_T& operator= (      ThisType_T&& arg) noexcept;

      private:

         /// Methods

            void m_correctMappingFunctorIfItIs(const ViewBase_T::FunctorInterface_T& functor);

         /// Variables

            std::shared_ptr<StoredFunctorType>                                                                                                              m_storedFunctorPtr;
            ContainerView<StoredType, SolidOrAbstract, FiniteOrInfinite, StoredFunctorType::flag_ConstOrMutatingCallOp_V, ViewPropertiesAlwaysMutable_If_m> m_view;
   };
}

#include "ContainerViewPlus_xtors.tpp"
#include "ContainerViewPlus_methods_public_other.tpp"
#include "ContainerViewPlus_methods_public_getters.tpp"
#include "ContainerViewPlus_methods_public_setters.tpp"
#include "ContainerViewPlus_methods_private.tpp"
#include "ContainerViewPlus_op_overloads.tpp"

#endif // ED_CONTAINER_VIEW_PLUS_HPP
