// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_VIEW_HPP
#define ED_CONTAINER_VIEW_HPP

#include "meta_ContainerView.hpp"
#include "I_ContainerViewBase.hpp"
#include "edeniumConfig_debugModeSettings.hpp"
#include "ConditionalTypeModifiers.hpp"
#include "TypeVariationsConcepts.hpp"

#include <cstdint>

namespace ed
{
   template <typename StoredType, char SolidOrAbstract, char FiniteOrInfinite, char ConstOrMutatingFunctorCallOp, char ViewPropertiesAlwaysMutable_If_m = ' '>
      requires(meta_ContainerView::flags::SolidOrAbstract             ::MustBeCorrect<SolidOrAbstract>                 {},
               meta_ContainerView::flags::FiniteOrInfinite            ::MustBeCorrect<FiniteOrInfinite>                {},
               meta_ContainerView::flags::ConstOrMutatingFunctorCallOp::MustBeCorrect<ConstOrMutatingFunctorCallOp>    {},
               meta_ContainerView::flags::ViewPropertiesAlwaysMutable ::MustBeCorrect<ViewPropertiesAlwaysMutable_If_m>{}, true)
   class ContainerView :public meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
   {
      using ViewBase_T = meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>;

      public:

         /// Constructors

            explicit ContainerView(      ViewBase_T::TargetInterface_T& target, ViewBase_T::FunctorInterface_T& mappingFunctor)                        noexcept requires(ViewBase_T::isInfinite_V);
            explicit ContainerView(const ViewBase_T::TargetInterface_T& target, ViewBase_T::FunctorInterface_T& mappingFunctor)                        noexcept requires(ViewBase_T::isInfinite_V);
            explicit ContainerView(      ViewBase_T::TargetInterface_T& target, ViewBase_T::FunctorInterface_T& mappingFunctor, const uintmax_t& size) noexcept requires(ViewBase_T::isFinite_V);
            explicit ContainerView(const ViewBase_T::TargetInterface_T& target, ViewBase_T::FunctorInterface_T& mappingFunctor, const uintmax_t& size) noexcept requires(ViewBase_T::isFinite_V);

         /// Destructor

            virtual ~ContainerView();

         /// Methods

            void repoint(      StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex)       requires(ViewBase_T::isSolid_V); //override
            void repoint(const StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex) const requires(ViewBase_T::isSolid_V); //override

            /// Getters

                     ViewBase_T::TargetInterface_T&  target        ()       noexcept(!config::debuggingEnabledFor_ContainerView_target)                                     override;
               const ViewBase_T::TargetInterface_T&  target        () const noexcept                                                                                        override;
                     ViewBase_T::FunctorInterface_T& mappingFunctor() const noexcept                                                                                        override;
                     uintmax_t                       size          () const noexcept                                                    requires(ViewBase_T::isFinite_V); //override

            /// Setters

               void set              (const uintmax_t&                      index,
                                      const StoredType&                     value)                         requires(ViewBase_T::isAbstract_V);                                           //override
               void setTarget        (      ViewBase_T::TargetInterface_T&  target)               noexcept                                                                                 override;
               void setTarget        (const ViewBase_T::TargetInterface_T&  target)         const noexcept requires(ViewBase_T::hasAlwaysMutableProperties_V);                           //override
               void setMappingFunctor(      ViewBase_T::FunctorInterface_T& mappingFunctor)       noexcept                                                                                 override;
               void setMappingFunctor(      ViewBase_T::FunctorInterface_T& mappingFunctor) const noexcept requires(ViewBase_T::hasAlwaysMutableProperties_V);                           //override
               void setSize          (const uintmax_t&                      size)                 noexcept requires(ViewBase_T::isFinite_V);                                             //override
               void setSize          (const uintmax_t&                      size)           const noexcept requires(ViewBase_T::isFinite_V && ViewBase_T::hasAlwaysMutableProperties_V); //override

         /// Operator overloads

            ConditionalConstReferenceL_T<meta_ContainerView::BaseViewInterface_T<StoredType, SolidOrAbstract, FiniteOrInfinite, ConstOrMutatingFunctorCallOp, ViewPropertiesAlwaysMutable_If_m>
                                         ::isSolid_V, StoredType> operator() (const uintmax_t& index) const;                                  //override
            StoredType&                                           operator() (const uintmax_t& index)        requires(ViewBase_T::isSolid_V); //override

      private:

         /// Methods

            uintmax_t m_mapIndex (const uintmax_t&                     index)  const;
            void      m_setTarget(const ViewBase_T::TargetInterface_T& target) const;

            template <POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
               void m_repointGeneric(AdequatePtrType& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex) requires(ViewBase_T::isSolid_V);

         /// Variables

            mutable ViewBase_T::TargetInterface_T*  m_target;
            mutable ViewBase_T::FunctorInterface_T* m_mappingFunctor;
            mutable bool                            m_targetIsConst;
   };
}

#include "ContainerView_xtors.tpp"
#include "ContainerView_methods_public_other.tpp"
#include "ContainerView_methods_public_getters.tpp"
#include "ContainerView_methods_public_setters.tpp"
#include "ContainerView_methods_private.tpp"
#include "ContainerView_op_overloads.tpp"

#include "ContainerViewPlus.hpp"

#endif // ED_CONTAINER_VIEW_HPP
