// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_UTILS_HPP
#define ED_CONTAINER_UTILS_HPP

#include "IA_ContainerFinite.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"

#include <cstdint>

namespace ed
{
   bool      isEmpty    (const IA_ContainerFinite& container);
   uintmax_t lastIndexOf(const IA_ContainerFinite& container);

   template <typename StoredType> const StoredType& firstOf(const I_ContainerSolid   <StoredType>& container) { return container(0); }
   template <typename StoredType>       StoredType& firstOf(      I_ContainerSolid   <StoredType>& container) { return container(0); }
   template <typename StoredType>       StoredType  firstOf(const I_ContainerAbstract<StoredType>& container) { return container(0); }

   template <typename StoredType> const StoredType& lastOf(const IM_ContainerSolidFinite   <StoredType>& container) { return container(lastIndexOf(container)); }
   template <typename StoredType>       StoredType& lastOf(      IM_ContainerSolidFinite   <StoredType>& container) { return container(lastIndexOf(container)); }
   template <typename StoredType>       StoredType  lastOf(const IM_ContainerAbstractFinite<StoredType>& container) { return container(lastIndexOf(container)); }
}

#endif // ED_CONTAINER_UTILS_HPP
