// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#include "ContainerUtils.hpp"

#include "edeniumConfig_debugModeSettings.hpp"
#include "_checkInterface_lastIndexOf.hpp"

namespace ed
{
   bool isEmpty(const IA_ContainerFinite& container)
   { return container.size() == 0; }

   uintmax_t lastIndexOf(const IA_ContainerFinite& container)
   {
      if constexpr (config::debuggingEnabledFor_lastIndexOf)
         _checkInterface_lastIndexOf(container);

      return container.size() - 1;
   }
}
