// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONTAINER_CONCEPTS_HPP
#define ED_CONTAINER_CONCEPTS_HPP

#include "I_Container.hpp"
#include "I_ContainerSolid.hpp"
#include "I_ContainerAbstract.hpp"
#include "IA_ContainerFinite.hpp"
#include "IM_ContainerSolidFinite.hpp"
#include "IM_ContainerAbstractFinite.hpp"
#include "_isInterface_Container_V.hpp"

#include <concepts>

namespace ed
{
   template <typename T> concept CONTAINER = requires { typename T::IsEdeniumContainer; };

   template <typename T> concept CONTAINER_SOLID    = CONTAINER<T> && requires { typename T::IsEdeniumContainerSolid;    };
   template <typename T> concept CONTAINER_ABSTRACT = CONTAINER<T> && requires { typename T::IsEdeniumContainerAbstract; };
   template <typename T> concept CONTAINER_FINITE   = CONTAINER<T> && std::derived_from<T, IA_ContainerFinite>;
   template <typename T> concept CONTAINER_INFINITE = CONTAINER<T> && !CONTAINER_FINITE<T>;

   template <typename T> concept CONTAINER_SOLID_FINITE      = CONTAINER_SOLID   <T> && CONTAINER_FINITE  <T> && requires { typename T::IsEdeniumContainerSolidFinite;    };
   template <typename T> concept CONTAINER_SOLID_INFINITE    = CONTAINER_SOLID   <T> && CONTAINER_INFINITE<T>;
   template <typename T> concept CONTAINER_ABSTRACT_FINITE   = CONTAINER_ABSTRACT<T> && CONTAINER_FINITE  <T> && requires { typename T::IsEdeniumContainerAbstractFinite; };
   template <typename T> concept CONTAINER_ABSTRACT_INFINITE = CONTAINER_ABSTRACT<T> && CONTAINER_INFINITE<T>;

   template <typename T> concept CONTAINER_INTERFACE_SOLID        = _isInterface_ContainerSolid_V      <T>;
   template <typename T> concept CONTAINER_INTERFACE_SOLID_FINITE = _isInterface_ContainerSolidFinite_V<T>;
   template <typename T> concept CONTAINER_INTERFACE_SOLID_ANY    = (CONTAINER_INTERFACE_SOLID         <T> || CONTAINER_INTERFACE_SOLID_FINITE<T>);

   template <typename T> concept CONTAINER_INTERFACE_ABSTRACT        = _isInterface_ContainerAbstract_V      <T>;
   template <typename T> concept CONTAINER_INTERFACE_ABSTRACT_FINITE = _isInterface_ContainerAbstractFinite_V<T>;
   template <typename T> concept CONTAINER_INTERFACE_ABSTRACT_ANY    = (CONTAINER_INTERFACE_ABSTRACT         <T> || CONTAINER_INTERFACE_ABSTRACT_FINITE<T>);

   template <typename T> concept CONTAINER_INTERFACE_FINITE_ANY = CONTAINER_INTERFACE_SOLID_FINITE<T> || CONTAINER_INTERFACE_ABSTRACT_FINITE<T>;
   template <typename T> concept CONTAINER_INTERFACE            = CONTAINER_INTERFACE_SOLID_ANY   <T> || CONTAINER_INTERFACE_ABSTRACT_ANY   <T>;
}

#endif // ED_CONTAINER_CONCEPTS_HPP
