// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_CONDITIONAL_TYPE_MODIFIERS_HPP
#define ED_CONDITIONAL_TYPE_MODIFIERS_HPP

#include <type_traits>

namespace ed
{
   template <bool Condition, typename PureType> using ConditionalConst_T           = std::conditional_t<Condition, const PureType,   PureType>;
   template <bool Condition, typename PureType> using ConditionalPointer_T         = std::conditional_t<Condition,       PureType*,  PureType>;
   template <bool Condition, typename PureType> using ConditionalReferenceL_T      = std::conditional_t<Condition,       PureType&,  PureType>;
   template <bool Condition, typename PureType> using ConditionalReferenceR_T      = std::conditional_t<Condition,       PureType&&, PureType>;
   template <bool Condition, typename PureType> using ConditionalConstReferenceL_T = std::conditional_t<Condition, const PureType&,  PureType>;
   template <bool Condition, typename PureType> using ConditionalConstReferenceR_T = std::conditional_t<Condition, const PureType&&, PureType>;
}

#endif // ED_CONDITIONAL_TYPE_MODIFIERS_HPP
