// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_ARRAY_XTORS_TPP
#define ED_ARRAY_XTORS_TPP

#include "ContainerUtils.hpp"

#include <utility>

namespace ed
{
   /// Constructors

      template <typename StoredType, uintmax_t Size>
         Array<StoredType, Size>
         ::Array()
            requires(std::constructible_from<StoredType>)
            : m_dataPtr(allocT<StoredType>(Size), &dealloc)
            { std::uninitialized_default_construct_n(&firstOf(*this), Size); }

      template <typename StoredType, uintmax_t Size>
         Array<StoredType, Size>
         ::Array(const Array<StoredType, Size>& arg)
            requires(std::constructible_from<StoredType, const StoredType&>)
            : m_dataPtr(allocT<StoredType>(Size), &dealloc)
            { std::uninitialized_copy_n(&firstOf(arg), Size, &firstOf(*this)); }

      template <typename StoredType, uintmax_t Size>
         Array<StoredType, Size>
         ::Array(Array<StoredType, Size>&& arg) noexcept
            : m_dataPtr(arg.m_dataPtr.release(), &dealloc) {}

      template <typename StoredType,   uintmax_t Size>
      template <typename FirstArgType, typename... RestArgTypes>
         Array<StoredType, Size>::Array(ed::EachFromArgs tag, FirstArgType firstArgForEachElem, RestArgTypes... restArgsForEachElem)
            requires(std::constructible_from<StoredType, FirstArgType, RestArgTypes...>)
            : m_dataPtr(allocT<StoredType>(Size), &dealloc)
            {
               StoredType* it = &firstOf(*this);
               for(uintmax_t i = 1; i < Size; ++i)
               {
                  new (it) StoredType(std::forward<FirstArgType>(firstArgForEachElem), std::forward<RestArgTypes>(restArgsForEachElem)...);
                  repointToNext(it);
               }
               new (it) StoredType(std::forward<FirstArgType>(firstArgForEachElem), std::forward<RestArgTypes>(restArgsForEachElem)...);
            }

   /// Destructor

      template <typename StoredType, uintmax_t Size>
         Array<StoredType, Size>
         ::~Array()
         {
            if(m_dataPtr != nullptr)
            {
               StoredType* it = &lastOf(*this);
               for(uintmax_t i = 1; i < Size; ++i)
               {
                  it->~StoredType();
                  repointToPrevious(it);
               }
               it->~StoredType();
            }
         }
}

#endif // ED_ARRAY_XTORS_TPP
