// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_ARRAY_OP_OVERLOADS_TPP
#define ED_ARRAY_OP_OVERLOADS_TPP

#include "_checkInterface_Array.hpp"
#include "ContainerUtils.hpp"

#include <algorithm>

namespace ed
{
   template <typename StoredType, uintmax_t Size>
      const StoredType&
         Array<StoredType, Size>
         ::operator() (const uintmax_t& index) const
         {
            if constexpr (config::debuggingEnabledFor_Array_op_call)
               _checkInterface_Array_op_call(index, size());

            return m_dataPtr[index];
         }

   template <typename StoredType, uintmax_t Size>
      StoredType&
         Array<StoredType, Size>
         ::operator() (const uintmax_t& index)
         {
            if constexpr (config::debuggingEnabledFor_Array_op_call)
               _checkInterface_Array_op_call(index, size());

            return m_dataPtr[index];
         }

   template <typename StoredType, uintmax_t Size>
      Array<StoredType, Size>&
         Array<StoredType, Size>
         ::operator= (Array<StoredType, Size>&& arg) noexcept
         {
            if(this != &arg)
               m_dataPtr.reset(arg.m_dataPtr.release());
            return *this;
         }

   template <typename StoredType, uintmax_t Size>
      Array<StoredType, Size>&
         Array<StoredType, Size>
         ::operator= (const Array<StoredType, Size>& arg)
            requires(std::copyable<StoredType>)
            {
               if(this != &arg)
                  std::copy_n(&firstOf(arg), Size, &firstOf(*this));
               return *this;
            }
}

#endif // ED_ARRAY_OP_OVERLOADS_TPP
