// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_ARRAY_METHODS_TPP
#define ED_ARRAY_METHODS_TPP

#include "_checkInterface_Array.hpp"

namespace ed
{
   /// Public

      template <typename StoredType, uintmax_t Size>
         void
            Array<StoredType, Size>
            ::repoint(StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex)
            { m_repointGeneric(pointer, currentIndex, targetIndex); }

      template <typename StoredType, uintmax_t Size>
         void
            Array<StoredType, Size>
            ::repoint(const StoredType*& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex) const
            { m_repointGeneric(pointer, currentIndex, targetIndex); }

      template <typename StoredType, uintmax_t Size>
         uintmax_t
            Array<StoredType, Size>
            ::size() const noexcept
            { return Size; }

      template <typename StoredType, uintmax_t Size>
      template <POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
         void
            Array<StoredType, Size>
            ::repointForward(AdequatePtrType& pointer, const uintmax_t& offset) const noexcept
            { pointer += offset; }

      template <typename StoredType, uintmax_t Size>
      template <POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
         void
            Array<StoredType, Size>
            ::repointBackward(AdequatePtrType& pointer, const uintmax_t& offset) const noexcept
            { pointer -= offset; }

      template <typename StoredType, uintmax_t Size>
      template <POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
         void
            Array<StoredType, Size>
            ::repointToNext(AdequatePtrType& pointer) const noexcept
            { pointer++; }

      template <typename StoredType, uintmax_t Size>
      template <POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
         void
            Array<StoredType, Size>
            ::repointToPrevious(AdequatePtrType& pointer) const noexcept
            { pointer--; }

   /// Private

      template <typename StoredType, uintmax_t Size>
      template <POINTER_TO_CONST_AGNOSTIC<StoredType> AdequatePtrType>
         void
            Array<StoredType, Size>
            ::m_repointGeneric(AdequatePtrType& pointer, const uintmax_t& currentIndex, const uintmax_t& targetIndex) const noexcept(!config::debuggingEnabledFor_Array_repoint)
            {
               if constexpr (config::debuggingEnabledFor_Array_repoint)
                  _checkInterface_Array_repoint(pointer, currentIndex, targetIndex, *this);

               if(targetIndex >= currentIndex)
                  repointForward(pointer, targetIndex - currentIndex);
               else
                  repointBackward(pointer, currentIndex - targetIndex);
            }
}

#endif // ED_ARRAY_METHODS_TPP
