// Copyright (C) 2025, Edensoft Apps
// Full notice in NOTICE.txt file you should have received along with this file

#ifndef ED_ANY_OF_HPP
#define ED_ANY_OF_HPP

#include <concepts>

namespace ed
{
   template <typename T, typename FirstAllowedType, typename SecondAllowedType, typename... RestOfAllowedTypes>
      concept ANY_OF = std::same_as<T, FirstAllowedType> || std::same_as<T, SecondAllowedType> || (std::same_as<T, RestOfAllowedTypes> || ...);
}

#endif // ED_ANY_OF_HPP
