# *Edenium: Making C++ crystal clear*

Edenium is a general-purpose C++ library designed with modularity, clarity and performance in mind. It aims to provide reliable building blocks for various types of programs as well as better designed and more intuitive alternatives to standard library features. This project is an attempt to make C++ more appealing both to beginner programmers (by offering a bundle of easy-to-use functionalities related to concepts commonly used in programming) and to professionals (by providing features highly customizable for different use cases, together with easy-to-read implementation and interfaces allowing easier custom modifications).

## Why that direction?

C++ standard library has its good sides, but in quite a few cases its features are overcomplicated, poorly designed and simply unattractive to people willing to learn how they work, and especially to people who would like to tinker with or expand them. Edenium is developed to serve as an alternative without these shortcomings, with potential to eventually become something bigger (for example, a multimedia library).

In addition to the purposes described above, Edenium is a project of great importance to Edensoft Apps as well. The development of this library is fueled by our need to have a solid foundation our future projects will be built on. So if you learn how Edenium works, it will be easier for you to understand how our future applications do their magic, and how to modify them.

## Library characteristics

* source-distributed (doesn't come with precompiled binaries)
* written in C++20, requires a compiler that supports it (GCC 10.5 is used during development)

## Features

In its current state, Edenium is a modest library, despite implementing many different features. They will be developed further in future releases.

Features:
* container interfaces
* static one-dimensional array class
* generic functions working on containers
* container views, together with some predefined basic view types
* functor interface (alternative to lambdas)
* library configuration files specifically designed to help you adjust the library behavior to your liking
* highly customizable error system making debugging easier
* various C++ concepts and metafunctions making metaprogramming easier
* memory allocation helper functions
* sizeof helpers
* detection of integer overflow on addition
...and more

## License

Edenium is distributed under [AGPL-3.0-or-later](https://www.gnu.org/licenses/agpl-3.0.html) license.